#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.DAL.HL7AL.UnitTests
{
	/// <summary>
	/// Summary description for CprsOmgMessage.
	/// </summary>
	[TestFixture]
	public class HL7AL_CprsOmgMessage : BaseTest 
	{
		[SetUp]
		protected void SetUp()
		{
			this.BaseSetUp();
		}

		[TearDown]
		protected void TearDown()
		{
		}

		[Test]
		public void GetOrderedTestbyCPRSOrderNumber_Pass()
		{
            DataTable dtPatient = DataCreator.GetRandomPatientRecord(true);
			Guid patientGuid = Guid.Empty;

			if (dtPatient.Rows.Count > 0)
			{
				patientGuid = (Guid)dtPatient.Rows[0][Common.VbecsTables.Patient.PatientGuid];
			}
			else
			{
				Assert.AreEqual(patientGuid, Guid.NewGuid(), "Patient does not exist");
				return;
			}

			Guid patientTreatmentGuid = Guid.NewGuid();
			string insertPatientTreatment = "INSERT INTO PATIENTTREATMENT (";
			insertPatientTreatment += Common.VbecsTables.PatientTreatment.PatientTreatmentGuid + ",";
			insertPatientTreatment += Common.VbecsTables.PatientTreatment.PatientGuid + ",";
			insertPatientTreatment += Common.VbecsTables.PatientTreatment.LastUpdateDate + ",";
			insertPatientTreatment += Common.VbecsTables.PatientTreatment.LastUpdateUser + ",";
			insertPatientTreatment += Common.VbecsTables.PatientTreatment.LastUpdateFunctionId + ")";
			insertPatientTreatment += "VALUES(";
			insertPatientTreatment += "'" + patientTreatmentGuid.ToString() + "',";
			insertPatientTreatment += "'" + patientGuid.ToString() + "',";
			insertPatientTreatment += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientTreatment += "'UnitTestUser',";
			insertPatientTreatment += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid patientOrderGuid = Guid.NewGuid();
			string insertPatientOrder = "INSERT INTO PATIENTORDER (";
			insertPatientOrder += Common.VbecsTables.PatientOrder.PatientOrderGuid + ",";
			insertPatientOrder += Common.VbecsTables.PatientOrder.PatientTreatmentGuid + ",";
			insertPatientOrder += Common.VbecsTables.PatientOrder.DivisionCode + ",";
			insertPatientOrder += Common.VbecsTables.PatientOrder.LastUpdateDate + ",";
			insertPatientOrder += Common.VbecsTables.PatientOrder.LastUpdateUser + ",";
			insertPatientOrder += Common.VbecsTables.PatientOrder.LastUpdateFunctionId + ")";
			insertPatientOrder += "VALUES(";
			insertPatientOrder += "'" + patientOrderGuid.ToString() + "',";
			insertPatientOrder += "'" + patientTreatmentGuid.ToString() + "',";
			insertPatientOrder += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertPatientOrder += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientOrder += "'UnitTestUser',";
			insertPatientOrder += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

            string cprsOrderNumber = SprocHelper.GetNewCprsOrderNumber();
			Guid orderedTestGuid = Guid.NewGuid();
			string insertOrderedTest = "INSERT INTO ORDEREDTEST (";
			insertOrderedTest += Common.VbecsTables.OrderedTest.OrderedTestGuid + ",";
			insertOrderedTest += Common.VbecsTables.OrderedTest.PatientOrderGuid + ",";
			insertOrderedTest += Common.VbecsTables.OrderedTest.OrderableTestId + ",";
			insertOrderedTest += Common.VbecsTables.OrderedTest.OrderStatusCode + ",";
			insertOrderedTest += Common.VbecsTables.OrderedTest.TaskStatusCode + ",";
			insertOrderedTest += Common.VbecsTables.OrderedTest.CprsOrderNumber + ",";
			insertOrderedTest += Common.VbecsTables.OrderedTest.DivisionCode + ",";
			insertOrderedTest += Common.VbecsTables.OrderedTest.LastUpdateDate + ",";
			insertOrderedTest += Common.VbecsTables.OrderedTest.LastUpdateUser + ",";
			insertOrderedTest += Common.VbecsTables.OrderedTest.LastUpdateFunctionId + ")";
			insertOrderedTest += "VALUES (";
			insertOrderedTest += "'" + orderedTestGuid.ToString() + "',";
			insertOrderedTest += "'" + patientOrderGuid.ToString() + "',";
			insertOrderedTest += "'4',";
			insertOrderedTest += "'A',";
			insertOrderedTest += "'P',";
            insertOrderedTest += "'" + cprsOrderNumber + "',";
			insertOrderedTest += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertOrderedTest += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertOrderedTest += "'UnitTestUser',";
			insertOrderedTest += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			UnitTestUtil.RunSQL(insertPatientTreatment);
			UnitTestUtil.RunSQL(insertPatientOrder);
			UnitTestUtil.RunSQL(insertOrderedTest);

			DataTable dtResult = new DataTable();
			try
			{
				dtResult = CprsOmgMessage.GetOrderedTestbyCPRSOrderNumber(cprsOrderNumber);
			}
			catch(Exception e)
			{
				throw(e);
			}
			finally
			{
				UnitTestUtil.RunSQL("DELETE FROM ORDEREDTEST WHERE ORDEREDTESTGUID = '" + orderedTestGuid.ToString() + "'");
				UnitTestUtil.RunSQL("DELETE FROM PATIENTORDER WHERE PATIENTORDERGUID = '" + patientOrderGuid.ToString() + "'");
				UnitTestUtil.RunSQL("DELETE FROM PATIENTTREATMENT WHERE PATIENTTREATMENTGUID = '" + patientTreatmentGuid.ToString() + "'");
			}

			Assert.IsTrue( dtResult.Rows.Count > 0 );
		}

		[Test]
		public void GetOrderedTestbyCPRSOrderNumber_Fail()
		{
			DataTable dtResult = CprsOmgMessage.GetOrderedTestbyCPRSOrderNumber("number");
			Assert.IsTrue( dtResult.Rows.Count == 0 );
		}

		[Test]
		public void GetOrderableTestIdOrComponentClassIdFromCprsOrderableItemId_Pass()
		{
			DataTable dtResult = CprsOmgMessage.GetOrderableTestIdOrComponentClassIdFromCprsOrderableItemId(2);
			Assert.IsTrue( dtResult.Rows.Count > 0 );
		}

		[Test]
		public void GetOrderableTestIdOrComponentClassIdFromCprsOrderableItemId_Fail()
		{
			DataTable dtResult = CprsOmgMessage.GetOrderableTestIdOrComponentClassIdFromCprsOrderableItemId(50);
			Assert.IsTrue( dtResult.Rows.Count == 0 );
		}

		[Test]
		public void GetOrderedComponentbyCPRSOrderNumber_Pass()
		{
            DataTable dtPatient = DataCreator.GetRandomPatientRecord(true);
			Guid patientGuid = Guid.Empty;

			if (dtPatient.Rows.Count > 0)
			{
				patientGuid = (Guid)dtPatient.Rows[0][Common.VbecsTables.Patient.PatientGuid];
			}
			else
			{
				Assert.AreEqual(patientGuid, Guid.NewGuid(), "Patient does not exist");
				return;
			}

			Guid patientTreatmentGuid = Guid.NewGuid();
			string insertPatientTreatment = "INSERT INTO PATIENTTREATMENT (";
			insertPatientTreatment += Common.VbecsTables.PatientTreatment.PatientTreatmentGuid + ",";
			insertPatientTreatment += Common.VbecsTables.PatientTreatment.PatientGuid + ",";
			insertPatientTreatment += Common.VbecsTables.PatientTreatment.LastUpdateDate + ",";
			insertPatientTreatment += Common.VbecsTables.PatientTreatment.LastUpdateUser + ",";
			insertPatientTreatment += Common.VbecsTables.PatientTreatment.LastUpdateFunctionId + ")";
			insertPatientTreatment += "VALUES(";
			insertPatientTreatment += "'" + patientTreatmentGuid.ToString() + "',";
			insertPatientTreatment += "'" + patientGuid.ToString() + "',";
			insertPatientTreatment += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientTreatment += "'UnitTestUser',";
			insertPatientTreatment += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid patientOrderGuid = Guid.NewGuid();
			string insertPatientOrder = "INSERT INTO PATIENTORDER (";
			insertPatientOrder += Common.VbecsTables.PatientOrder.PatientOrderGuid + ",";
			insertPatientOrder += Common.VbecsTables.PatientOrder.PatientTreatmentGuid + ",";
			insertPatientOrder += Common.VbecsTables.PatientOrder.DivisionCode + ",";
			insertPatientOrder += Common.VbecsTables.PatientOrder.LastUpdateDate + ",";
			insertPatientOrder += Common.VbecsTables.PatientOrder.LastUpdateUser + ",";
			insertPatientOrder += Common.VbecsTables.PatientOrder.LastUpdateFunctionId + ")";
			insertPatientOrder += "VALUES(";
			insertPatientOrder += "'" + patientOrderGuid.ToString() + "',";
			insertPatientOrder += "'" + patientTreatmentGuid.ToString() + "',";
			insertPatientOrder += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertPatientOrder += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientOrder += "'UnitTestUser',";
			insertPatientOrder += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

            string cprsOrderNumber = SprocHelper.GetNewCprsOrderNumber();
			Guid orderedComponentGuid = Guid.NewGuid();
			string insertOrderedComponent = "INSERT INTO ORDEREDCOMPONENT (";
			insertOrderedComponent += Common.VbecsTables.OrderedComponent.OrderedComponentGuid + ",";
			insertOrderedComponent += Common.VbecsTables.OrderedComponent.PatientOrderGuid + ",";
			insertOrderedComponent += Common.VbecsTables.OrderedComponent.ComponentClassId + ",";
			insertOrderedComponent += Common.VbecsTables.OrderedComponent.CprsOrderNumber + ",";
			insertOrderedComponent += Common.VbecsTables.OrderedComponent.RequiredUnitQuantity + ",";
			insertOrderedComponent += Common.VbecsTables.OrderedComponent.OrderStatusCode + ",";
			insertOrderedComponent += Common.VbecsTables.OrderedComponent.RequiredDatetime + ",";
			insertOrderedComponent += Common.VbecsTables.OrderedComponent.TaskStatusCode + ",";
			insertOrderedComponent += Common.VbecsTables.OrderedComponent.DivisionCode + ",";
			insertOrderedComponent += Common.VbecsTables.OrderedComponent.LastUpdateDate + ",";
			insertOrderedComponent += Common.VbecsTables.OrderedComponent.LastUpdateUser + ",";
			insertOrderedComponent += Common.VbecsTables.OrderedComponent.LastUpdateFunctionId + ")";
			insertOrderedComponent += "VALUES (";
			insertOrderedComponent += "'" + orderedComponentGuid.ToString() + "',";
			insertOrderedComponent += "'" + patientOrderGuid.ToString() + "',";
			insertOrderedComponent += "'1',";
			insertOrderedComponent += "'" + cprsOrderNumber + "',";
			insertOrderedComponent += "'2',";
			insertOrderedComponent += "'A',";
			insertOrderedComponent += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now.AddDays(3)) + "',";
			insertOrderedComponent += "'N',";
			insertOrderedComponent += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertOrderedComponent += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertOrderedComponent += "'UnitTestUser',";
			insertOrderedComponent += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			UnitTestUtil.RunSQL(insertPatientTreatment);
			UnitTestUtil.RunSQL(insertPatientOrder);
			UnitTestUtil.RunSQL(insertOrderedComponent);

			DataTable dtResult = new DataTable();
			try
			{
				dtResult = CprsOmgMessage.GetOrderedComponentbyCPRSOrderNumber(cprsOrderNumber);
			}
			catch(Exception e)
			{
				throw(e);
			}
			finally
			{
				UnitTestUtil.RunSQL("DELETE FROM ORDEREDCOMPONENT WHERE ORDEREDCOMPONENTGUID = '" + orderedComponentGuid.ToString() + "'");
				UnitTestUtil.RunSQL("DELETE FROM PATIENTORDER WHERE PATIENTORDERGUID = '" + patientOrderGuid.ToString() + "'");
				UnitTestUtil.RunSQL("DELETE FROM PATIENTTREATMENT WHERE PATIENTTREATMENTGUID = '" + patientTreatmentGuid.ToString() + "'");
			}

			Assert.IsTrue( dtResult.Rows.Count > 0 );
		}

		[Test]
		public void GetOrderedComponentbyCPRSOrderNumber_Fail()
		{
			DataTable dtResult = CprsOmgMessage.GetOrderedComponentbyCPRSOrderNumber("number");
			Assert.IsTrue( dtResult.Rows.Count == 0 );
		}

		[Test]
		public void GetPatientOrderbyOrderGroupNumber_Pass()
		{
            DataTable dtPatient = DataCreator.GetRandomPatientRecord(true);
			Guid patientGuid = Guid.Empty;

			if (dtPatient.Rows.Count > 0)
			{
				patientGuid = (Guid)dtPatient.Rows[0][Common.VbecsTables.Patient.PatientGuid];
			}
			else
			{
				Assert.AreEqual(patientGuid, Guid.NewGuid(), "Patient does not exist");
				return;
			}

			Guid patientTreatmentGuid = Guid.NewGuid();
			string insertPatientTreatment = "INSERT INTO PATIENTTREATMENT (";
			insertPatientTreatment += Common.VbecsTables.PatientTreatment.PatientTreatmentGuid + ",";
			insertPatientTreatment += Common.VbecsTables.PatientTreatment.PatientGuid + ",";
			insertPatientTreatment += Common.VbecsTables.PatientTreatment.LastUpdateDate + ",";
			insertPatientTreatment += Common.VbecsTables.PatientTreatment.LastUpdateUser + ",";
			insertPatientTreatment += Common.VbecsTables.PatientTreatment.LastUpdateFunctionId + ")";
			insertPatientTreatment += "VALUES(";
			insertPatientTreatment += "'" + patientTreatmentGuid.ToString() + "',";
			insertPatientTreatment += "'" + patientGuid.ToString() + "',";
			insertPatientTreatment += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientTreatment += "'UnitTestUser',";
			insertPatientTreatment += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid patientOrderGuid = Guid.NewGuid();
			string insertPatientOrder = "INSERT INTO PATIENTORDER (";
			insertPatientOrder += Common.VbecsTables.PatientOrder.PatientOrderGuid + ",";
			insertPatientOrder += Common.VbecsTables.PatientOrder.PatientTreatmentGuid + ",";
			insertPatientOrder += Common.VbecsTables.PatientOrder.OrderGroupNumber + ",";
			insertPatientOrder += Common.VbecsTables.PatientOrder.DivisionCode + ",";
			insertPatientOrder += Common.VbecsTables.PatientOrder.LastUpdateDate + ",";
			insertPatientOrder += Common.VbecsTables.PatientOrder.LastUpdateUser + ",";
			insertPatientOrder += Common.VbecsTables.PatientOrder.LastUpdateFunctionId + ")";
			insertPatientOrder += "VALUES(";
			insertPatientOrder += "'" + patientOrderGuid.ToString() + "',";
			insertPatientOrder += "'" + patientTreatmentGuid.ToString() + "',";
			insertPatientOrder += "'12345',";
			insertPatientOrder += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertPatientOrder += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientOrder += "'UnitTestUser',";
			insertPatientOrder += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			UnitTestUtil.RunSQL(insertPatientTreatment);
			UnitTestUtil.RunSQL(insertPatientOrder);

			DataTable dtResult = new DataTable();
			try
			{
				dtResult = CprsOmgMessage.GetPatientOrderbyOrderGroupNumber("12345");
			}
			catch(Exception e)
			{
				throw(e);
			}
			finally
			{
				UnitTestUtil.RunSQL("DELETE FROM PATIENTORDER WHERE PATIENTORDERGUID = '" + patientOrderGuid.ToString() + "'");
				UnitTestUtil.RunSQL("DELETE FROM PATIENTTREATMENT WHERE PATIENTTREATMENTGUID = '" + patientTreatmentGuid.ToString() + "'");
			}

			Assert.IsTrue( dtResult.Rows.Count > 0 );
		}

		[Test]
		public void GetPatientOrderbyOrderGroupNumber_Fail()
		{
			DataTable dtResult = CprsOmgMessage.GetPatientOrderbyOrderGroupNumber("number");
			Assert.IsTrue( dtResult.Rows.Count == 0 );
		}

		[Test]
		public void GetHl7Patient_Pass()
		{
			DataTable dtPatient = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM Patient WHERE PatientIcn IS NOT NULL");
			Guid patientGuid = Guid.Empty;

			string patientIcn = "";
			string vistaPatientId = "";

			if (dtPatient.Rows.Count > 0)
			{
				patientGuid = (Guid)dtPatient.Rows[0][Common.VbecsTables.Patient.PatientGuid];
				patientIcn = dtPatient.Rows[0][Common.VbecsTables.Patient.PatientIcn].ToString();
				vistaPatientId = dtPatient.Rows[0][Common.VbecsTables.Patient.VistaPatientId].ToString();

				DataTable dtResult = CprsOmgMessage.GetHl7Patient(patientIcn, vistaPatientId);
				
				Assert.AreEqual(1, dtResult.Rows.Count, "Rows.Count");
			}
			else
			{
				Assert.IsTrue(false, "Patient does not exist");
			}
		}

		[Test]
		public void GetHl7Patient_Fail()
		{
			DataTable dtResult = CprsOmgMessage.GetHl7Patient("", "1");
			Assert.IsTrue( dtResult.Rows.Count == 0 );
		}

		[Test]
		public void GetHl7PatientTreatment_Pass()
		{
            DataTable dtPatient = DataCreator.GetRandomPatientRecord(true);
			Guid patientGuid = Guid.Empty;

			if (dtPatient.Rows.Count > 0)
			{
				patientGuid = (Guid)dtPatient.Rows[0][Common.VbecsTables.Patient.PatientGuid];
			}
			else
			{
				Assert.AreEqual(patientGuid, Guid.NewGuid(), "Patient does not exist");
				return;
			}

			Guid patientTreatmentGuid = Guid.NewGuid();
			string insertPatientTreatment = "INSERT INTO PATIENTTREATMENT (";
			insertPatientTreatment += Common.VbecsTables.PatientTreatment.PatientTreatmentGuid + ",";
			insertPatientTreatment += Common.VbecsTables.PatientTreatment.PatientGuid + ",";
			insertPatientTreatment += Common.VbecsTables.PatientTreatment.PatientTreatingFacility + ",";
			insertPatientTreatment += Common.VbecsTables.PatientTreatment.PatientLocation + ",";
			insertPatientTreatment += Common.VbecsTables.PatientTreatment.PatientRoomBed + ",";
			insertPatientTreatment += Common.VbecsTables.PatientTreatment.InPatientIndicator + ",";
			insertPatientTreatment += Common.VbecsTables.PatientTreatment.PatientAdmittingDiagnosis + ",";
			insertPatientTreatment += Common.VbecsTables.PatientTreatment.LastUpdateDate + ",";
			insertPatientTreatment += Common.VbecsTables.PatientTreatment.LastUpdateUser + ",";
			insertPatientTreatment += Common.VbecsTables.PatientTreatment.LastUpdateFunctionId + ")";
			insertPatientTreatment += "VALUES(";
			insertPatientTreatment += "'" + patientTreatmentGuid.ToString() + "',";
			insertPatientTreatment += "'" + patientGuid.ToString() + "',";
			insertPatientTreatment += "'TestFacility',";
			insertPatientTreatment += "'TestLocation',";
			insertPatientTreatment += "'TestRoomBed',";
			insertPatientTreatment += "'1',";
			insertPatientTreatment += "'TestDiagnosis',";
			insertPatientTreatment += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientTreatment += "'UnitTestUser',";
			insertPatientTreatment += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";
			
			UnitTestUtil.RunSQL(insertPatientTreatment);

			DataTable dtPatientTreatment = new DataTable();
			dtPatientTreatment.Columns.Add(Common.VbecsTables.PatientTreatment.PatientGuid, typeof(Guid));
			dtPatientTreatment.Columns.Add(Common.VbecsTables.PatientTreatment.PatientTreatingFacility);
			dtPatientTreatment.Columns.Add(Common.VbecsTables.PatientTreatment.PatientLocation);
			dtPatientTreatment.Columns.Add(Common.VbecsTables.PatientTreatment.PatientRoomBed);
			dtPatientTreatment.Columns.Add(Common.VbecsTables.PatientTreatment.InPatientIndicator, typeof(bool));
			dtPatientTreatment.Columns.Add(Common.VbecsTables.PatientTreatment.PatientAdmittingDiagnosis);

			DataRow drPatientTreatment = dtPatientTreatment.NewRow();
			drPatientTreatment[Common.VbecsTables.PatientTreatment.PatientTreatingFacility] = "TestFacility";
			drPatientTreatment[Common.VbecsTables.PatientTreatment.PatientLocation] = "TestLocation";
			drPatientTreatment[Common.VbecsTables.PatientTreatment.PatientRoomBed] = "TestRoomBed";
			drPatientTreatment[Common.VbecsTables.PatientTreatment.InPatientIndicator] = true;
			drPatientTreatment[Common.VbecsTables.PatientTreatment.PatientAdmittingDiagnosis] = "TestDiagnosis";
			drPatientTreatment[Common.VbecsTables.PatientTreatment.PatientGuid] = patientGuid;
			dtPatientTreatment.Rows.Add(drPatientTreatment);

			DataTable dtResult = new DataTable();
			try
			{
				dtResult = CprsOmgMessage.GetHl7PatientTreatment(dtPatientTreatment);
			}
			catch(Exception e)
			{
				throw(e);
			}
			finally
			{
				UnitTestUtil.RunSQL("DELETE FROM PATIENTTREATMENT WHERE PATIENTTREATMENTGUID = '" + patientTreatmentGuid.ToString() + "'");
			}

			Assert.IsTrue( dtResult.Rows.Count > 0 );
		}

		[Test]
		public void GetHl7PatientTreatment_Fail()
		{
			DataTable dtPatientTreatment = new DataTable();
			dtPatientTreatment.Columns.Add(Common.VbecsTables.PatientTreatment.PatientGuid, typeof(Guid));
			dtPatientTreatment.Columns.Add(Common.VbecsTables.PatientTreatment.PatientTreatingFacility);
			dtPatientTreatment.Columns.Add(Common.VbecsTables.PatientTreatment.PatientLocation);
			dtPatientTreatment.Columns.Add(Common.VbecsTables.PatientTreatment.PatientRoomBed);
			dtPatientTreatment.Columns.Add(Common.VbecsTables.PatientTreatment.InPatientIndicator, typeof(bool));
			dtPatientTreatment.Columns.Add(Common.VbecsTables.PatientTreatment.PatientAdmittingDiagnosis);

			DataRow drPatientTreatment = dtPatientTreatment.NewRow();
			drPatientTreatment[Common.VbecsTables.PatientTreatment.PatientTreatingFacility] = "";
			drPatientTreatment[Common.VbecsTables.PatientTreatment.PatientLocation] = "";
			drPatientTreatment[Common.VbecsTables.PatientTreatment.PatientRoomBed] = "";
			drPatientTreatment[Common.VbecsTables.PatientTreatment.InPatientIndicator] = true;
			drPatientTreatment[Common.VbecsTables.PatientTreatment.PatientAdmittingDiagnosis] = "";
			drPatientTreatment[Common.VbecsTables.PatientTreatment.PatientGuid] = Guid.NewGuid();
			dtPatientTreatment.Rows.Add(drPatientTreatment);

			DataTable dtResult = CprsOmgMessage.GetHl7PatientTreatment(dtPatientTreatment);
			Assert.IsTrue( dtResult.Rows.Count == 0 );
		}

		[Test]
		public void CancelPatientOrder_OrderedTest_Pass()
		{
            DataTable dtPatient = DataCreator.GetRandomPatientRecord(true);
			Guid patientGuid = Guid.Empty;

			if (dtPatient.Rows.Count > 0)
			{
				patientGuid = (Guid)dtPatient.Rows[0][Common.VbecsTables.Patient.PatientGuid];
			}
			else
			{
				Assert.AreEqual(patientGuid, Guid.NewGuid(), "Patient does not exist");
				return;
			}

			Guid patientTreatmentGuid = Guid.NewGuid();
			string insertPatientTreatment = "INSERT INTO PATIENTTREATMENT (";
			insertPatientTreatment += Common.VbecsTables.PatientTreatment.PatientTreatmentGuid + ",";
			insertPatientTreatment += Common.VbecsTables.PatientTreatment.PatientGuid + ",";
			insertPatientTreatment += Common.VbecsTables.PatientTreatment.LastUpdateDate + ",";
			insertPatientTreatment += Common.VbecsTables.PatientTreatment.LastUpdateUser + ",";
			insertPatientTreatment += Common.VbecsTables.PatientTreatment.LastUpdateFunctionId + ")";
			insertPatientTreatment += "VALUES(";
			insertPatientTreatment += "'" + patientTreatmentGuid.ToString() + "',";
			insertPatientTreatment += "'" + patientGuid.ToString() + "',";
			insertPatientTreatment += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientTreatment += "'UnitTestUser',";
			insertPatientTreatment += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid patientOrderGuid = Guid.NewGuid();
			string insertPatientOrder = "INSERT INTO PATIENTORDER (";
			insertPatientOrder += Common.VbecsTables.PatientOrder.PatientOrderGuid + ",";
			insertPatientOrder += Common.VbecsTables.PatientOrder.PatientTreatmentGuid + ",";
			insertPatientOrder += Common.VbecsTables.PatientOrder.DivisionCode + ",";
			insertPatientOrder += Common.VbecsTables.PatientOrder.LastUpdateDate + ",";
			insertPatientOrder += Common.VbecsTables.PatientOrder.LastUpdateUser + ",";
			insertPatientOrder += Common.VbecsTables.PatientOrder.LastUpdateFunctionId + ")";
			insertPatientOrder += "VALUES(";
			insertPatientOrder += "'" + patientOrderGuid.ToString() + "',";
			insertPatientOrder += "'" + patientTreatmentGuid.ToString() + "',";
			insertPatientOrder += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertPatientOrder += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientOrder += "'UnitTestUser',";
			insertPatientOrder += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

            
			Guid orderedTestGuid = Guid.NewGuid();
			string insertOrderedTest = "INSERT INTO ORDEREDTEST (";
			insertOrderedTest += Common.VbecsTables.OrderedTest.OrderedTestGuid + ",";
			insertOrderedTest += Common.VbecsTables.OrderedTest.PatientOrderGuid + ",";
			insertOrderedTest += Common.VbecsTables.OrderedTest.OrderableTestId + ",";
			insertOrderedTest += Common.VbecsTables.OrderedTest.OrderStatusCode + ",";
			insertOrderedTest += Common.VbecsTables.OrderedTest.TaskStatusCode + ",";
			insertOrderedTest += Common.VbecsTables.OrderedTest.CprsOrderNumber + ",";
			insertOrderedTest += Common.VbecsTables.OrderedTest.VbecsOrderNumber + ",";
			insertOrderedTest += Common.VbecsTables.OrderedTest.DivisionCode + ",";
			insertOrderedTest += Common.VbecsTables.OrderedTest.LastUpdateDate + ",";
			insertOrderedTest += Common.VbecsTables.OrderedTest.LastUpdateUser + ",";
			insertOrderedTest += Common.VbecsTables.OrderedTest.LastUpdateFunctionId + ")";
			insertOrderedTest += "VALUES (";
			insertOrderedTest += "'" + orderedTestGuid.ToString() + "',";
			insertOrderedTest += "'" + patientOrderGuid.ToString() + "',";
			insertOrderedTest += "'4',";
			insertOrderedTest += "'A',";
			insertOrderedTest += "'P',";
            insertOrderedTest += "'" + SprocHelper.GetNewCprsOrderNumber() + "',";
			insertOrderedTest += "'1234',";
			insertOrderedTest += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertOrderedTest += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertOrderedTest += "'UnitTestUser',";
			insertOrderedTest += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			UnitTestUtil.RunSQL(insertPatientTreatment);
			UnitTestUtil.RunSQL(insertPatientOrder);
			UnitTestUtil.RunSQL(insertOrderedTest);

			DataTable dtTest = new DataTable();
			dtTest.Columns.Add(Common.VbecsTables.OrderedTest.OrderedTestGuid, typeof(Guid));
			dtTest.Columns.Add(Common.VbecsTables.OrderedTest.PatientOrderGuid, typeof(Guid));
			dtTest.Columns.Add(Common.VbecsTables.OrderedTest.VbecsOrderNumber);
			dtTest.Columns.Add(Common.VbecsTables.OrderedTest.LastUpdateFunctionId, typeof(int));

			DataRow drTest = dtTest.NewRow();
			drTest[Common.VbecsTables.OrderedTest.OrderedTestGuid] = orderedTestGuid;
			drTest[Common.VbecsTables.OrderedTest.PatientOrderGuid] = patientOrderGuid;
			drTest[Common.VbecsTables.OrderedTest.VbecsOrderNumber] = "1234";
			drTest[Common.VbecsTables.OrderedTest.LastUpdateFunctionId] = Convert.ToInt32(Common.UpdateFunction.UnitTests);
			dtTest.Rows.Add(drTest);

			int result = -1;
			try
			{
				result = new CprsOmgMessage().CancelPatientOrder(dtTest);
			}
			catch(Exception e)
			{
				throw(e);
			}
			finally
			{
				UnitTestUtil.RunSQL("DELETE FROM ORDEREDTEST WHERE ORDEREDTESTGUID = '" + orderedTestGuid.ToString() + "'");
				UnitTestUtil.RunSQL("DELETE FROM PATIENTORDER WHERE PATIENTORDERGUID = '" + patientOrderGuid.ToString() + "'");
				UnitTestUtil.RunSQL("DELETE FROM PATIENTTREATMENT WHERE PATIENTTREATMENTGUID = '" + patientTreatmentGuid.ToString() + "'");
			}

			Assert.IsTrue( result == 0 );
		}

		[Test]
		public void CancelPatientOrder_OrderedComponent_Pass()
		{
            DataTable dtPatient = DataCreator.GetRandomPatientRecord(true);
			Guid patientGuid = Guid.Empty;

			if (dtPatient.Rows.Count > 0)
			{
				patientGuid = (Guid)dtPatient.Rows[0][Common.VbecsTables.Patient.PatientGuid];
			}
			else
			{
				Assert.AreEqual(patientGuid, Guid.NewGuid(), "Patient does not exist");
				return;
			}

			Guid patientTreatmentGuid = Guid.NewGuid();
			string insertPatientTreatment = "INSERT INTO PATIENTTREATMENT (";
			insertPatientTreatment += Common.VbecsTables.PatientTreatment.PatientTreatmentGuid + ",";
			insertPatientTreatment += Common.VbecsTables.PatientTreatment.PatientGuid + ",";
			insertPatientTreatment += Common.VbecsTables.PatientTreatment.LastUpdateDate + ",";
			insertPatientTreatment += Common.VbecsTables.PatientTreatment.LastUpdateUser + ",";
			insertPatientTreatment += Common.VbecsTables.PatientTreatment.LastUpdateFunctionId + ")";
			insertPatientTreatment += "VALUES(";
			insertPatientTreatment += "'" + patientTreatmentGuid.ToString() + "',";
			insertPatientTreatment += "'" + patientGuid.ToString() + "',";
			insertPatientTreatment += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientTreatment += "'UnitTestUser',";
			insertPatientTreatment += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid patientOrderGuid = Guid.NewGuid();
			string insertPatientOrder = "INSERT INTO PATIENTORDER (";
			insertPatientOrder += Common.VbecsTables.PatientOrder.PatientOrderGuid + ",";
			insertPatientOrder += Common.VbecsTables.PatientOrder.PatientTreatmentGuid + ",";
			insertPatientOrder += Common.VbecsTables.PatientOrder.DivisionCode + ",";
			insertPatientOrder += Common.VbecsTables.PatientOrder.LastUpdateDate + ",";
			insertPatientOrder += Common.VbecsTables.PatientOrder.LastUpdateUser + ",";
			insertPatientOrder += Common.VbecsTables.PatientOrder.LastUpdateFunctionId + ")";
			insertPatientOrder += "VALUES(";
			insertPatientOrder += "'" + patientOrderGuid.ToString() + "',";
			insertPatientOrder += "'" + patientTreatmentGuid.ToString() + "',";
			insertPatientOrder += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertPatientOrder += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertPatientOrder += "'UnitTestUser',";
			insertPatientOrder += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			Guid orderedComponentGuid = Guid.NewGuid();
			string insertOrderedComponent = "INSERT INTO ORDEREDCOMPONENT (";
			insertOrderedComponent += Common.VbecsTables.OrderedComponent.OrderedComponentGuid + ",";
			insertOrderedComponent += Common.VbecsTables.OrderedComponent.PatientOrderGuid + ",";
			insertOrderedComponent += Common.VbecsTables.OrderedComponent.ComponentClassId + ",";
			insertOrderedComponent += Common.VbecsTables.OrderedComponent.CprsOrderNumber + ",";
			insertOrderedComponent += Common.VbecsTables.OrderedComponent.RequiredUnitQuantity + ",";
			insertOrderedComponent += Common.VbecsTables.OrderedComponent.OrderStatusCode + ",";
			insertOrderedComponent += Common.VbecsTables.OrderedComponent.RequiredDatetime + ",";
			insertOrderedComponent += Common.VbecsTables.OrderedComponent.TaskStatusCode + ",";
			insertOrderedComponent += Common.VbecsTables.OrderedComponent.DivisionCode + ",";
			insertOrderedComponent += Common.VbecsTables.OrderedComponent.LastUpdateDate + ",";
			insertOrderedComponent += Common.VbecsTables.OrderedComponent.LastUpdateUser + ",";
			insertOrderedComponent += Common.VbecsTables.OrderedComponent.LastUpdateFunctionId + ")";
			insertOrderedComponent += "VALUES (";
			insertOrderedComponent += "'" + orderedComponentGuid.ToString() + "',";
			insertOrderedComponent += "'" + patientOrderGuid.ToString() + "',";
			insertOrderedComponent += "'1',";
            insertOrderedComponent += "'" + SprocHelper.GetNewCprsOrderNumber() + "',";
			insertOrderedComponent += "'2',";
			insertOrderedComponent += "'A',";
			insertOrderedComponent += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now.AddDays(3)) + "',";
			insertOrderedComponent += "'N',";
			insertOrderedComponent += "'" + Common.LogonUser.LogonUserDivisionCode + "',";
			insertOrderedComponent += "'" + Common.VBECSDateTime.FormatDateTimeString(DateTime.Now) + "',";
			insertOrderedComponent += "'UnitTestUser',";
			insertOrderedComponent += "'" + Convert.ToInt32(Common.UpdateFunction.UnitTests) + "')";

			UnitTestUtil.RunSQL(insertPatientTreatment);
			UnitTestUtil.RunSQL(insertPatientOrder);
			UnitTestUtil.RunSQL(insertOrderedComponent);

			DataTable dtTest = new DataTable();
			dtTest.Columns.Add(Common.VbecsTables.OrderedComponent.OrderedComponentGuid, typeof(Guid));
			dtTest.Columns.Add(Common.VbecsTables.OrderedComponent.PatientOrderGuid, typeof(Guid));
			dtTest.Columns.Add(Common.VbecsTables.OrderedComponent.ComponentClassId, typeof(int));
			dtTest.Columns.Add(Common.VbecsTables.OrderedComponent.CprsOrderNumber);
			dtTest.Columns.Add(Common.VbecsTables.OrderedComponent.VbecsOrderNumber);
			dtTest.Columns.Add(Common.VbecsTables.OrderedComponent.RequiredUnitQuantity, typeof(int));
			dtTest.Columns.Add(Common.VbecsTables.OrderedComponent.SpecimenStatusCode, typeof(char));
			dtTest.Columns.Add(Common.VbecsTables.OrderedComponent.PreOpIndicator, typeof(bool));
			dtTest.Columns.Add(Common.VbecsTables.OrderedComponent.OrderUrgencyCode, typeof(char));
			dtTest.Columns.Add(Common.VbecsTables.OrderedComponent.RequiredDatetime, typeof(DateTime));
			dtTest.Columns.Add(Common.VbecsTables.OrderedComponent.LabOrderNumber);
			dtTest.Columns.Add(Common.VbecsTables.OrderedComponent.DivisionCode);
			dtTest.Columns.Add(Common.VbecsTables.OrderedComponent.LastUpdateFunctionId, typeof(int));

			DataRow drTest = dtTest.NewRow();
			drTest[Common.VbecsTables.OrderedComponent.OrderedComponentGuid] = orderedComponentGuid;
			drTest[Common.VbecsTables.OrderedComponent.PatientOrderGuid] = patientOrderGuid;
			drTest[Common.VbecsTables.OrderedComponent.ComponentClassId] = 1;
            drTest[Common.VbecsTables.OrderedComponent.CprsOrderNumber] = "" + SprocHelper.GetNewCprsOrderNumber() + "";
			drTest[Common.VbecsTables.OrderedComponent.VbecsOrderNumber] = "1234";
			drTest[Common.VbecsTables.OrderedComponent.RequiredUnitQuantity] = 1;
			drTest[Common.VbecsTables.OrderedComponent.SpecimenStatusCode] = 'R';
			drTest[Common.VbecsTables.OrderedComponent.PreOpIndicator] = 1;
			drTest[Common.VbecsTables.OrderedComponent.OrderUrgencyCode] = 'R';
			drTest[Common.VbecsTables.OrderedComponent.RequiredDatetime] = DateTime.Now.AddDays(3);
			drTest[Common.VbecsTables.OrderedComponent.LabOrderNumber] = "2345";
			drTest[Common.VbecsTables.OrderedComponent.DivisionCode] = Common.LogonUser.LogonUserDivisionCode;
			drTest[Common.VbecsTables.OrderedComponent.LastUpdateFunctionId] = Convert.ToInt32(Common.UpdateFunction.UnitTests);
			dtTest.Rows.Add(drTest);

			int result = -1;
			try
			{
				result = new CprsOmgMessage().CancelPatientOrder(dtTest);
			}
			catch(Exception e)
			{
				throw(e);
			}
			finally
			{
				UnitTestUtil.RunSQL("DELETE FROM ORDEREDCOMPONENT WHERE ORDEREDCOMPONENTGUID = '" + orderedComponentGuid.ToString() + "'");
				UnitTestUtil.RunSQL("DELETE FROM PATIENTORDER WHERE PATIENTORDERGUID = '" + patientOrderGuid.ToString() + "'");
				UnitTestUtil.RunSQL("DELETE FROM PATIENTTREATMENT WHERE PATIENTTREATMENTGUID = '" + patientTreatmentGuid.ToString() + "'");
			}

			Assert.IsTrue( result == 0 );
		}

		[Test]
		public void CancelPatientOrder_Fail()
		{
			int result = new CprsOmgMessage().CancelPatientOrder(new DataTable());
			Assert.IsTrue( result != 0 );
		}

		/// <summary>
		/// </summary>
		/// <returns>Guid</returns>
		private static Guid CreatePatientTestData(BOL.AboRh aboRh)
		{
			Guid patientGuid = Guid.NewGuid();

			DataTable dtInsPatient = SprocHelper.GetInsertPatientSprocTable(patientGuid);
			bool retValue = BOL.Patient.InsertPatient(dtInsPatient.Rows[0], Common.UpdateFunction.UnitTests);
			Assert.AreEqual(true, retValue, "PatientInsert");

			UnitTestUtil.RunSQL("UPDATE Patient SET BloodTypeCode = '" + aboRh.Abo.ToString() + "', RhFactorCode = '" + aboRh.RHFactorCode + "' WHERE PatientGuid = '" + patientGuid.ToString() + "'");

			return patientGuid;
		}

		[Test]
		public void UpdateVistaPatientOrder_OrderedTest_Pass()
		{
			Guid patientGuid = Guid.NewGuid();
			DataTable dtPatient = SprocHelper.GetInsertPatientSprocTable(patientGuid);
			dtPatient.Columns.Remove("RecordStatusCode");
			//
			Guid patientTreatmentGuid = Guid.NewGuid();
			DataTable dtPatientTreatment = SprocHelper.GetInsertPatientTreatmentSprocTable(patientTreatmentGuid, patientGuid);
			//
			Guid patientOrderGuid = Guid.NewGuid();
			DataTable dtPatientOrder = SprocHelper.GetInsertPatientOrderSprocTable(patientOrderGuid, patientTreatmentGuid);
			//
			Guid orderedTestGuid = Guid.NewGuid();
			//
			DataTable dtTest = new DataTable();
			dtTest.Columns.Add(Common.VbecsTables.OrderedTest.OrderedTestGuid, typeof(Guid));
			dtTest.Columns.Add(Common.VbecsTables.OrderedTest.PatientOrderGuid, typeof(Guid));
			dtTest.Columns.Add(Common.VbecsTables.OrderedTest.VbecsOrderNumber);
			dtTest.Columns.Add(Common.VbecsTables.OrderedTest.LastUpdateFunctionId, typeof(int));
			//
			DataRow drTest = dtTest.NewRow();
			drTest[Common.VbecsTables.OrderedTest.OrderedTestGuid] = orderedTestGuid;
			drTest[Common.VbecsTables.OrderedTest.PatientOrderGuid] = patientOrderGuid;
			drTest[Common.VbecsTables.OrderedTest.VbecsOrderNumber] = "1234";
			drTest[Common.VbecsTables.OrderedTest.LastUpdateFunctionId] = Convert.ToInt32(Common.UpdateFunction.UnitTests);
			dtTest.Rows.Add(drTest);
			//
			int result = -1;
			try
			{
				result = CprsOmgMessage.UpdateVistaPatientOrder( dtPatient, dtPatientTreatment, dtPatientOrder, dtTest);
			}
			catch(Exception e)
			{
				throw(e);
			}
			//
			Assert.IsTrue( result == 0 );
			//
			//
			//
			//
			result = -1;
			try
			{
				result = CprsOmgMessage.UpdateVistaPatientOrder( new DataTable(), dtPatientTreatment, dtPatientOrder, dtTest);
			}
			catch(Exception e)
			{
				throw(e);
			}
			//
			Assert.IsTrue( result == 0 );
			//
			//
			//
			//
			result = -1;
			try
			{
				result = CprsOmgMessage.UpdateVistaPatientOrder( new DataTable(), new DataTable(), dtPatientOrder, dtTest);
			}
			catch(Exception e)
			{
				throw(e);
			}
			//
			Assert.IsTrue( result == 0 );
			//
			//
			//
			//
			result = -1;
			try
			{
				result = CprsOmgMessage.UpdateVistaPatientOrder( new DataTable(), new DataTable(), new DataTable(), dtTest);
			}
			catch(Exception e)
			{
				throw(e);
			}
			finally
			{
				UnitTestUtil.RunSQL("DELETE FROM ORDEREDTEST WHERE ORDEREDTESTGUID = '" + orderedTestGuid.ToString() + "'");
				UnitTestUtil.RunSQL("DELETE FROM PATIENTORDER WHERE PATIENTORDERGUID = '" + patientOrderGuid.ToString() + "'");
				UnitTestUtil.RunSQL("DELETE FROM PATIENTTREATMENT WHERE PATIENTTREATMENTGUID = '" + patientTreatmentGuid.ToString() + "'");
			}
			//
			Assert.IsTrue( result == 0 );
		}

		[Test]
		public void UpdateVistaPatientOrder_OrderedComponent_Pass()
		{
			Guid patientGuid = Guid.NewGuid();
			DataTable dtPatient = SprocHelper.GetInsertPatientSprocTable(patientGuid);
			dtPatient.Columns.Remove("RecordStatusCode");
			//
			Guid patientTreatmentGuid = Guid.NewGuid();
			DataTable dtPatientTreatment = SprocHelper.GetInsertPatientTreatmentSprocTable(patientTreatmentGuid, patientGuid);
			//
			Guid patientOrderGuid = Guid.NewGuid();
			DataTable dtPatientOrder = SprocHelper.GetInsertPatientOrderSprocTable(patientOrderGuid, patientTreatmentGuid);
			//
			Guid orderedComponentGuid = Guid.NewGuid();
			//
			DataTable dtTest = new DataTable();
			dtTest.Columns.Add(Common.VbecsTables.OrderedComponent.OrderedComponentGuid, typeof(Guid));
			dtTest.Columns.Add(Common.VbecsTables.OrderedComponent.PatientOrderGuid, typeof(Guid));
			dtTest.Columns.Add(Common.VbecsTables.OrderedComponent.ComponentClassId, typeof(int));
			dtTest.Columns.Add(Common.VbecsTables.OrderedComponent.CprsOrderNumber);
			dtTest.Columns.Add(Common.VbecsTables.OrderedComponent.VbecsOrderNumber);
			dtTest.Columns.Add(Common.VbecsTables.OrderedComponent.RequiredUnitQuantity, typeof(int));
			dtTest.Columns.Add(Common.VbecsTables.OrderedComponent.SpecimenStatusCode, typeof(char));
			dtTest.Columns.Add(Common.VbecsTables.OrderedComponent.PreOpIndicator, typeof(bool));
			dtTest.Columns.Add(Common.VbecsTables.OrderedComponent.OrderUrgencyCode, typeof(char));
			dtTest.Columns.Add(Common.VbecsTables.OrderedComponent.RequiredDatetime, typeof(DateTime));
			dtTest.Columns.Add(Common.VbecsTables.OrderedComponent.LabOrderNumber);
			dtTest.Columns.Add(Common.VbecsTables.OrderedComponent.DivisionCode);
			dtTest.Columns.Add(Common.VbecsTables.OrderedComponent.LastUpdateFunctionId, typeof(int));
			//
			DataRow drTest = dtTest.NewRow();
			drTest[Common.VbecsTables.OrderedComponent.OrderedComponentGuid] = orderedComponentGuid;
			drTest[Common.VbecsTables.OrderedComponent.PatientOrderGuid] = patientOrderGuid;
			drTest[Common.VbecsTables.OrderedComponent.ComponentClassId] = 1;
            drTest[Common.VbecsTables.OrderedComponent.CprsOrderNumber] = SprocHelper.GetNewCprsOrderNumber();
			drTest[Common.VbecsTables.OrderedComponent.VbecsOrderNumber] = "1234";
			drTest[Common.VbecsTables.OrderedComponent.RequiredUnitQuantity] = 1;
			drTest[Common.VbecsTables.OrderedComponent.SpecimenStatusCode] = 'R';
			drTest[Common.VbecsTables.OrderedComponent.PreOpIndicator] = 1;
			drTest[Common.VbecsTables.OrderedComponent.OrderUrgencyCode] = 'R';
			drTest[Common.VbecsTables.OrderedComponent.RequiredDatetime] = DateTime.Now.AddDays(3);
			drTest[Common.VbecsTables.OrderedComponent.LabOrderNumber] = "2345";
			drTest[Common.VbecsTables.OrderedComponent.DivisionCode] = Common.LogonUser.LogonUserDivisionCode;
			drTest[Common.VbecsTables.OrderedComponent.LastUpdateFunctionId] = Convert.ToInt32(Common.UpdateFunction.UnitTests);
			dtTest.Rows.Add(drTest);
			//
			int result = -1;
			try
			{
				result = CprsOmgMessage.UpdateVistaPatientOrder( dtPatient, dtPatientTreatment, dtPatientOrder, dtTest);
			}
			catch(Exception e)
			{
				throw(e);
			}	
			//
			Assert.IsTrue( result == 0 );
			//
			//
			//
			//
			result = -1;
			try
			{
				result = CprsOmgMessage.UpdateVistaPatientOrder( new DataTable(), new DataTable(), new DataTable(), dtTest);
			}
			catch(Exception e)
			{
				throw(e);
			}
			finally
			{
				UnitTestUtil.RunSQL("DELETE FROM ORDEREDCOMPONENT WHERE ORDEREDCOMPONENTGUID = '" + orderedComponentGuid.ToString() + "'");
				UnitTestUtil.RunSQL("DELETE FROM PATIENTORDER WHERE PATIENTORDERGUID = '" + patientOrderGuid.ToString() + "'");
				UnitTestUtil.RunSQL("DELETE FROM PATIENTTREATMENT WHERE PATIENTTREATMENTGUID = '" + patientTreatmentGuid.ToString() + "'");
			}
			//
			Assert.IsTrue( result == 0 );
		}

		[Test]
		public void UpdateVistaPatientOrder_Fail()
		{
			int result = CprsOmgMessage.UpdateVistaPatientOrder(new DataTable(), new DataTable(), new DataTable(), new DataTable());
			Assert.IsTrue( result != 0 );
		}

		[Test]
		public void UpdatePatientPreviousResults_Pass()
		{
			DataTable dtPatientTest = new DataTable();
			dtPatientTest.Columns.Add(Common.VbecsTables.PatientTest.RecordStatusCode, typeof(char));
			dtPatientTest.Columns.Add(Common.VbecsTables.PatientTest.LastUpdateFunctionId, typeof(int));

			DataRow drPatientTest = dtPatientTest.NewRow();
			drPatientTest[Common.VbecsTables.PatientTest.RecordStatusCode] = 'A';
			drPatientTest[Common.VbecsTables.PatientTest.LastUpdateFunctionId] = Convert.ToInt32(Common.UpdateFunction.UnitTests);
			dtPatientTest.Rows.Add(drPatientTest);

			int result = CprsOmgMessage.UpdatePatientPreviousResults(dtPatientTest);
			Assert.IsTrue(result == 0);
		}

		[Test]
		public void UpdatePatientPreviousResults_Fail()
		{
			int result = CprsOmgMessage.UpdatePatientPreviousResults(new DataTable());
			Assert.IsTrue(result != 0);
		}

		[Test]
		public void GetOrderTableTypeID_Pass()
		{
			string result = CprsOmgMessage.GetOrderTableTypeID("1");
			Assert.IsTrue(result == "test");
		}
	
		[Test]
		public void GetOrderTableTypeID_Fail()
		{
			string result = CprsOmgMessage.GetOrderTableTypeID("");
			Assert.IsTrue(result == "ERROR");
		}
	}
}
#endif
